//
// Copyright 2000 by Craig Stuart Sapp, All Rights Reserved.
// Programmer:    Craig Stuart Sapp <craig@ccrma.stanford.edu>
// Creation Date: Thu Jun 29 21:43:18 PDT 2000 
// Last Modified: Thu Jun 29 21:43:22 PDT 2000 
// Filename:      ...sig.sapp.org/include/sigInfo/Enum_embel.h
// Web Address:   http://sig.sapp.org/include/sigInfo/Enum_embel.h
// Syntax:        C++; museinfo
//
// Description:   Enumerations for the Humdrum **embel interpretation.
//                for chord tone identification.
//

#ifndef _ENUM_EMBEL_H_INCLUDED
#define _ENUM_EMBEL_H_INCLUDED

#include "Enum_basic.h"

#define E_embel_aln        (1)    
#define E_embel_ant        (2)    
#define E_embel_app        (3)    
#define E_embel_apt        (4)    
#define E_embel_arp        (5)    
#define E_embel_arp7       (6)    
#define E_embel_aun        (7)    
#define E_embel_chg        (8)    
#define E_embel_cln        (9)    
#define E_embel_ct         (10)    
#define E_embel_ct7        (11)    
#define E_embel_cun        (12)    
#define E_embel_cup        (13)    
#define E_embel_et         (14)    
#define E_embel_ln         (15)    
#define E_embel_ped        (16)    
#define E_embel_rep        (17)    
#define E_embel_ret        (18)    
#define E_embel_23ret      (19)    
#define E_embel_78ret      (20)    
#define E_embel_sus        (21)    
#define E_embel_43sus      (22)    
#define E_embel_98sus      (23)    
#define E_embel_76sus      (24)    
#define E_embel_un         (25)    
#define E_embel_un7        (26)    
#define E_embel_upt        (27)    
#define E_embel_upt7       (28)    

#define E_embel_aln_name   "aln"
#define E_embel_ant_name   "ant"
#define E_embel_app_name   "app"
#define E_embel_apt_name   "apt"
#define E_embel_arp_name   "arp"
#define E_embel_arp7_name  "arp7"
#define E_embel_aun_name   "aun"
#define E_embel_chg_name   "chg"
#define E_embel_cln_name   "cln"
#define E_embel_ct_name    "ct"
#define E_embel_ct7_name   "ct7"
#define E_embel_cun_name   "cun"
#define E_embel_cup_name   "cup"
#define E_embel_et_name    "et"
#define E_embel_ln_name    "ln"
#define E_embel_ped_name   "ped"
#define E_embel_rep_name   "rep"
#define E_embel_ret_name   "ret"
#define E_embel_23ret_name "23ret"
#define E_embel_78ret_name "78ret"
#define E_embel_sus_name   "sus"
#define E_embel_43sus_name "43sus"
#define E_embel_98sus_name "98sus"
#define E_embel_76sus_name "76sus"
#define E_embel_un_name    "un"
#define E_embel_un7_name   "un7"
#define E_embel_upt_name   "upt"
#define E_embel_upt7_name  "upt7"

#endif  /* _ENUM_EMBEL_H_INCLUDED */



// md5sum: b130cdc42b8c34ff87ed45c8b4d3bfd6 Enum_embel.h [20001204]
